package ru.yandex.solomon.alert.notification;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface DispatchRule {
    boolean ignoreMute();

    boolean isTimeToRepeat(EvaluationStatus.Code code, Duration past);

    boolean isSubscribedOn(EvaluationStatus.Code code);

    // TODO: maybe deliver first OK in webhooks
    // now delivering only for juggler
    default boolean skipFirstOk() {
        return true;
    }
}
