package ru.yandex.solomon.alert.notification;

import java.time.Duration;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class DispatchRuleFactory {
    private static final DispatchRule DEV_NULL = new DispatchRule() {
        @Override
        public boolean ignoreMute() {
            return false;
        }

        @Override
        public boolean isTimeToRepeat(EvaluationStatus.Code code, Duration past) {
            return false;
        }

        @Override
        public boolean isSubscribedOn(EvaluationStatus.Code code) {
            return true;
        }
    };

    public static DispatchRule statusFiltering(Set<EvaluationStatus.Code> notifyCodes, Duration repeatNotifyDelay) {
        return new StatusFilteringDispatchRule(notifyCodes, repeatNotifyDelay, false);
    }

    public static DispatchRule statusFilteringRepeatOks(Set<EvaluationStatus.Code> notifyCodes, Duration repeatNotifyDelay) {
        return new StatusFilteringDispatchRule(notifyCodes, repeatNotifyDelay, true);
    }

    public static DispatchRule notifyRepeating(Set<EvaluationStatus.Code> notifyCodes) {
        return new RepeatingDispatchRule(notifyCodes);
    }

    public static DispatchRule notifyOnce(Set<EvaluationStatus.Code> notifyCodes) {
        return new OnceDispatchRule(notifyCodes);
    }

    public static DispatchRule devNull() {
        return DEV_NULL;
    }

    public static DispatchRule defaults() {
        return DEFAULTS;
    }

    private static final DispatchRule DEFAULTS = new DispatchRule() {
        @Override
        public boolean ignoreMute() {
            return true;
        }

        @Override
        public boolean isTimeToRepeat(EvaluationStatus.Code code, Duration past) {
            return true;
        }

        @Override
        public boolean isSubscribedOn(EvaluationStatus.Code code) {
            return true;
        }
    };
}
