package ru.yandex.solomon.alert.notification;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertKey;


/**
 * @author Vladimir Gordiychuk
 */
public final class NotificationKey {
    private final AlertKey alertKey;
    private final String notificationId;

    public NotificationKey(AlertKey alertKey, String notificationId) {
        this.alertKey = alertKey;
        this.notificationId = notificationId;
    }

    public static NotificationKey of(Alert alert, String notificationId) {
        return new NotificationKey(alert.getKey(), notificationId);
    }

    public AlertKey getAlertKey() {
        return alertKey;
    }

    public String getNotificationId() {
        return notificationId;
    }

    public String getProjectId() {
        return alertKey.getProjectId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NotificationKey that = (NotificationKey) o;

        if (!alertKey.equals(that.alertKey)) return false;
        return notificationId.equals(that.notificationId);
    }

    @Override
    public int hashCode() {
        int result = alertKey.hashCode();
        result = 31 * result + notificationId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("alertKey", alertKey)
                .add("notificationId", notificationId)
                .toString();
    }
}
