package ru.yandex.solomon.alert.notification;

import java.util.EnumMap;
import java.util.Map;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.alert.notification.domain.NotificationType;

/**
 * @author Vladimir Gordiychuk
 */
public class NotificationServiceMetrics implements MetricSupplier {
    private final EnumMap<NotificationType, ChannelMetrics> channelByType;

    public NotificationServiceMetrics() {
        EnumMap<NotificationType, ChannelMetrics> channelMetricsByType = new EnumMap<>(NotificationType.class);
        for (NotificationType type : NotificationType.values()) {
            channelMetricsByType.put(type, new ChannelMetrics(Labels.of("type", type.name())));
        }
        this.channelByType = channelMetricsByType;
    }

    public ChannelMetrics getChannelMetrics(NotificationType type) {
        return channelByType.get(type);
    }

    public void combine(NotificationServiceMetrics metrics) {
        for (Map.Entry<NotificationType, ChannelMetrics> entry : channelByType.entrySet()) {
            ChannelMetrics left = entry.getValue();
            ChannelMetrics right = metrics.channelByType.get(entry.getKey());
            left.combine(right);
        }
    }

    @Override
    public int estimateCount() {
        return channelByType.values()
                .stream()
                .mapToInt(ChannelMetrics::estimateCount)
                .sum();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        ChannelMetrics total = new ChannelMetrics(Labels.of("type", "total"));
        for (ChannelMetrics metrics : channelByType.values()) {
            total.combine(metrics);
            metrics.append(tsMillis, commonLabels, consumer);
        }
        total.append(tsMillis, commonLabels, consumer);
    }
}
