package ru.yandex.solomon.alert.notification;

import java.time.Duration;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class OnceDispatchRule implements DispatchRule {
    private final Set<EvaluationStatus.Code> notifyCodes;

    OnceDispatchRule(Set<EvaluationStatus.Code> notifyCodes) {
        this.notifyCodes = notifyCodes;
    }

    @Override
    public boolean ignoreMute() {
        return false;
    }

    @Override
    public boolean isSubscribedOn(EvaluationStatus.Code code) {
        return notifyCodes.contains(code);
    }

    @Override
    public boolean isTimeToRepeat(EvaluationStatus.Code code, Duration pastTime) {
        return false;
    }
}
