package ru.yandex.solomon.alert.notification;

import java.time.Duration;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class StatusFilteringDispatchRule implements DispatchRule {
    private final Set<EvaluationStatus.Code> notifyCodes;
    private final Duration repeatNotifyDelay;
    private final boolean repeatOks;

    StatusFilteringDispatchRule(Set<EvaluationStatus.Code> notifyCodes, Duration repeatNotifyDelay, boolean repeatOks) {
        this.notifyCodes = notifyCodes;
        this.repeatNotifyDelay = repeatNotifyDelay;
        this.repeatOks = repeatOks;
    }

    @Override
    public boolean ignoreMute() {
        return false;
    }

    @Override
    public boolean isSubscribedOn(EvaluationStatus.Code code) {
        return notifyCodes.contains(code);
    }

    @Override
    public boolean isTimeToRepeat(EvaluationStatus.Code code, Duration pastTime) {
        if (!repeatOks && code == EvaluationStatus.Code.OK) {
            return false;
        }

        return !repeatNotifyDelay.isZero() && pastTime.compareTo(repeatNotifyDelay) >= 0;
    }
}
