package ru.yandex.solomon.alert.notification.channel;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.ChannelConfig;
import ru.yandex.solomon.alert.notification.DispatchRule;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public abstract class AbstractNotificationChannel<T extends Notification> implements NotificationChannel {
    protected final T notification;

    protected AbstractNotificationChannel(T notification) {
        this.notification = notification;
    }

    protected static NotificationStatus mergeStatuses(List<NotificationStatus> statuses) {
        if (statuses.isEmpty()) {
            return NotificationStatus.OBSOLETE.withDescription("No recipients");
        } else if (statuses.size() == 1) {
            return statuses.get(0);
        }

        var result = statuses.get(0);
        for (var status : statuses) {
            if (status.getCode() == NotificationStatus.Code.SUCCESS) {
                result = status;
            }
        }

        return result;
    }

    @Nonnull
    @Override
    final public String getId() {
        return notification.getId();
    }

    @Override
    public T getNotification() {
        return notification;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Nonnull
    @Override
    final public String getProjectId() {
        return notification.getProjectId();
    }

    @Override
    final public NotificationType getType() {
        return notification.getType();
    }

    protected abstract DispatchRule makeDispatchRule(ChannelConfig configOverride);

    @Override
    final public DispatchRule getDispatchRule(ChannelConfig config) {
        return makeDispatchRule(config);
    }

    @Override
    public String toString() {
        return "NotificationChannel{type=" + getType().toString() +
                ", projectId=" + getProjectId() +
                ", id=" + getId() + "}";
    }
}
