package ru.yandex.solomon.alert.notification.channel;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertType;
import ru.yandex.solomon.alert.domain.SubAlert;
import ru.yandex.solomon.alert.rule.AlertMuteStatus;
import ru.yandex.solomon.alert.rule.AlertProcessingState;
import ru.yandex.solomon.alert.rule.EvaluationState;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class Event {
    private final Alert alert;
    private final AlertProcessingState state;

    public Event(Alert alert, AlertProcessingState state) {
        this.alert = alert;
        this.state = state;
    }

    public Alert getAlert() {
        return alert;
    }

    public EvaluationState getState() {
        return state.evaluationState();
    }

    public AlertMuteStatus getMuteStatus() {
        return state.alertMuteStatus();
    }

    public AlertProcessingState getAlertProcessingState() {
        return state;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("state", state)
                .toString();
    }

    public AlertApiKey getAlertApiKey() {
        final String alertId;
        final String subAlertId;

        if (alert.getAlertType() == AlertType.SUB_ALERT) {
            subAlertId = alert.getId();
            alertId = ((SubAlert) alert).getParent().getId();
        } else {
            subAlertId = "";
            alertId = alert.getId();
        }

        return new AlertApiKey(alert.getProjectId(), alertId, subAlertId);
    }
}
