package ru.yandex.solomon.alert.notification.channel;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.ChannelConfig;
import ru.yandex.solomon.alert.notification.DispatchRule;
import ru.yandex.solomon.alert.notification.DispatchRuleFactory;
import ru.yandex.solomon.alert.notification.domain.Notification;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class FailedInitNotificationChannel extends AbstractNotificationChannel<Notification> {
    private final Throwable throwable;

    public FailedInitNotificationChannel(Notification notification, Throwable throwable) {
        super(notification);
        this.throwable = throwable;
    }

    @Override
    protected DispatchRule makeDispatchRule(ChannelConfig config) {
        return DispatchRuleFactory.notifyOnce(
            config.getNotifyAboutStatusesOrDefault(notification.getNotifyAboutStatus()));
    }

    @Nonnull
    @Override
    public CompletableFuture<NotificationStatus> send(Instant latestSuccessSend, Event event) {
        return CompletableFuture.failedFuture(throwable);
    }

    @Override
    public void close() {
    }
}
