package ru.yandex.solomon.alert.notification.channel;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;

import ru.yandex.solomon.alert.domain.ChannelConfig;
import ru.yandex.solomon.alert.notification.DispatchRule;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;

/**
 * @author Vladimir Gordiychuk
 */
@ThreadSafe
@ParametersAreNonnullByDefault
public interface NotificationChannel extends AutoCloseable {
    @Nonnull
    String getId();

    @Nonnull
    String getProjectId();

    NotificationType getType();

    /**
     * @param latestSuccessSend time when latest {@link NotificationStatus#SUCCESS} occurs on
     *                          channel or {@link Instant#EPOCH} if success stories absent
     * @param event             event to send
     */
    @Nonnull
    CompletableFuture<NotificationStatus> send(Instant latestSuccessSend, Event event);

    DispatchRule getDispatchRule(ChannelConfig configOverride);

    @Override
    void close();

    boolean isDefault();

    Notification getNotification();
}
