package ru.yandex.solomon.alert.notification.channel;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface NotificationChannelFactory {
    // If several factories with same type are registered, the one with
    // the biggest priority wins
    Map<NotificationType, Integer> getSupportTypes();

    /**
     * Prepare channel to send notifications
     */
    @Nonnull
    NotificationChannel createChannel(Notification notification);
}
