package ru.yandex.solomon.alert.notification.channel.cloud;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.notification.channel.AbstractNotificationChannel;
import ru.yandex.solomon.alert.notification.domain.Notification;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public abstract class AbstractCloudNotificationChannel<T extends Notification> extends AbstractNotificationChannel<T> {
    private final NotifyClient client;
    private final CloudAuthClient authClient;

    public AbstractCloudNotificationChannel(T notification, NotifyClient client, CloudAuthClient authClient) {
        super(notification);
        this.client = client;
        this.authClient = authClient;
    }

    public NotifyClient getNotifyClient() {
        return client;
    }

    public CompletableFuture<Boolean> isAuthorizedToReadData(String folderId, String userId) {
        return authClient.isAuthorizedToReadData(folderId, userId);
    }

}
