package ru.yandex.solomon.alert.notification.channel.cloud.dto;

import java.util.Objects;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Vladimir Gordiychuk
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class NotifyDto<T> {
    @JsonProperty("type")
    private final String type;
    @JsonProperty("receiver")
    public String receiver;
    @JsonProperty("uid")
    public String iamUserId;
    @JsonProperty("data")
    public final T data;

    public NotifyDto(@Nonnull String type, T data) {
        this.type = Objects.requireNonNull(type);
        this.data = data;
    }

    @Override
    public String toString() {
        return "NotifyDto{" +
            "type='" + type + '\'' +
            ", receiver='" + receiver + '\'' +
            ", iamUserId='" + iamUserId + '\'' +
            ", data=" + data +
            '}';
    }
}
