package ru.yandex.solomon.alert.notification.channel.cloud.dto;

import java.util.List;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Ivan Tsybulin
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class NotifyDtoV1<T> {
    /** Template type name */
    @JsonProperty("type")
    private final String templateType;

    /** IAM user id, optional */
    @JsonProperty("userId")
    public String iamUserId;

    /** Send to owners of the cloud, optional */
    @JsonProperty("cloudId")
    public String cloudId;

    /** Override language, can be "ru" or "en" */
    @JsonProperty("lang")
    public String language;

    /** List of transports to use, can contain "mail", "sms" and "web" */
    @JsonProperty("transports")
    public List<String> transports;

    @JsonProperty("data")
    public final T data;

    public NotifyDtoV1(@Nonnull String templateType, T payload) {
        this.templateType = templateType;
        this.data = payload;
    }

    @Override
    public String toString() {
        return "NotifyDtoV1{" +
                "type='" + templateType + '\'' +
                (StringUtils.isEmpty(iamUserId) ? "" : ", userId='" + iamUserId + '\'') +
                (StringUtils.isEmpty(cloudId) ? "" : ", cloudId='" + cloudId + '\'') +
                (StringUtils.isEmpty(language) ? "" : ", language='" + language + '\'') +
                (transports == null || transports.isEmpty() ? "" : ", transports=" + transports) +
                ", data=" + data +
                '}';
    }
}
