package ru.yandex.solomon.alert.notification.channel.cloud.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.annotations.VisibleForTesting;

import ru.yandex.solomon.alert.graph.Line;

/**
 * @author Ivan Tsybulin
 */
@VisibleForTesting
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ThresholdAlertGraph {
    public double alarmLevel;
    public Double warnLevel;
    public String comparison;
    public String aggregation;
    public long nowMillis;
    public long windowMillis;
    public Range range;
    public List<Line> lines;

    @Override
    public String toString() {
        return "ThresholdAlertGraph{" +
                "alarmLevel=" + alarmLevel +
                ", warnLevel=" + warnLevel +
                ", comparison='" + comparison + '\'' +
                ", nowMillis=" + nowMillis +
                ", windowMillis=" + windowMillis +
                ", lines=" + lines +
                '}';
    }
}
