package ru.yandex.solomon.alert.notification.channel.cloud.email;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.solomon.alert.graph.GraphLoader;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.CloudAuthClient;
import ru.yandex.solomon.alert.notification.channel.cloud.NotifyClient;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.email.CloudEmailNotification;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class CloudEmailNotificationChannelFactory implements NotificationChannelFactory {
    @WillNotClose
    private final NotifyClient notifyClient;
    private final CloudAuthClient authClient;
    private final GraphLoader graphLoader;

    public CloudEmailNotificationChannelFactory(NotifyClient notifyClient, CloudAuthClient authClient, GraphLoader graphLoader) {
        this.notifyClient = notifyClient;
        this.authClient = authClient;
        this.graphLoader = graphLoader;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.CLOUD_EMAIL, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        return new CloudEmailNotificationChannel((CloudEmailNotification) notification, notifyClient, authClient, graphLoader);
    }
}
