package ru.yandex.solomon.alert.notification.channel.cloud.push;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.CloudAuthClient;
import ru.yandex.solomon.alert.notification.channel.cloud.NotifyClient;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.push.CloudPushNotification;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class CloudPushNotificationChannelFactory implements NotificationChannelFactory {
    @WillNotClose
    private final NotifyClient notifyClient;
    private final CloudAuthClient authClient;

    public CloudPushNotificationChannelFactory(
            NotifyClient notifyClient,
            CloudAuthClient authClient)
    {
        this.notifyClient = notifyClient;
        this.authClient = authClient;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.CLOUD_PUSH, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        return new CloudPushNotificationChannel((CloudPushNotification) notification, notifyClient, authClient);
    }
}
