package ru.yandex.solomon.alert.notification.channel.cloud.sms;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.CloudAuthClient;
import ru.yandex.solomon.alert.notification.channel.cloud.NotifyClient;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.sms.CloudSmsNotification;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class CloudSmsNotificationChannelFactory implements NotificationChannelFactory {
    @WillNotClose
    private final NotifyClient notifyClient;
    private final CloudAuthClient authClient;
    private final UrlShortener urlShortener;
    private final TemplateVarsFactory templateVarsFactory;

    public CloudSmsNotificationChannelFactory(
            NotifyClient notifyClient,
            CloudAuthClient authClient,
            UrlShortener urlShortener,
            TemplateVarsFactory templateVarsFactory)
    {
        this.notifyClient = notifyClient;
        this.authClient = authClient;
        this.urlShortener = urlShortener;
        this.templateVarsFactory = templateVarsFactory;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.CLOUD_SMS, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        return new CloudSmsNotificationChannel((CloudSmsNotification) notification, notifyClient, authClient, urlShortener, templateVarsFactory);
    }
}
