package ru.yandex.solomon.alert.notification.channel.datalens;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.solomon.alert.graph.GraphLoader;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.cloud.NotifyClient;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.email.DatalensEmailNotification;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class DatalensEmailNotificationChannelFactory implements NotificationChannelFactory {
    @WillNotClose
    private final NotifyClient notifyClient;
    private final GraphLoader graphLoader;

    public DatalensEmailNotificationChannelFactory(NotifyClient notifyClient, GraphLoader graphLoader) {
        this.notifyClient = notifyClient;
        this.graphLoader = graphLoader;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.DATALENS_EMAIL, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        return new DatalensEmailNotificationChannel((DatalensEmailNotification) notification, notifyClient, graphLoader);
    }
}
