package ru.yandex.solomon.alert.notification.channel.email;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import ru.yandex.commune.mail.MailMessage;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;

/**
 * @author Vladimir Gordiychuk
 */
public class AsyncEmailClient implements EmailClient {
    private MailTransport transport;

    public AsyncEmailClient(MailTransport transport) {
        this.transport = transport;
    }

    @Override
    public CompletableFuture<NotificationStatus> send(MailMessage message) {
        return transport.send(new MailRequest(message, System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L)));
    }

    @Override
    public void close() {
    }
}
