package ru.yandex.solomon.alert.notification.channel.email;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

import ru.yandex.solomon.alert.inject.spring.notification.EmailTemplate;
import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.email.EmailNotification;
import ru.yandex.solomon.alert.template.TemplateFactory;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class EmailNotificationChannelFactory implements NotificationChannelFactory {
    @WillNotClose
    private final EmailClient emailClient;
    // TODO: config
    private final TemplateFactory templateFactory;
    private final EmailTemplate template;
    @WillNotClose
    private final ScheduledExecutorService executorService;
    private final TemplateVarsFactory variablesFactory;

    public EmailNotificationChannelFactory(
            @WillNotClose EmailClient emailClient,
            @WillNotClose ScheduledExecutorService executorService,
            TemplateFactory templateFactory,
            TemplateVarsFactory variablesFactory,
            EmailTemplate template)
    {
        this.emailClient = emailClient;
        this.executorService = executorService;
        this.templateFactory = templateFactory;
        this.variablesFactory = variablesFactory;
        this.template = template;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.EMAIL, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        if (notification.getType() != NotificationType.EMAIL) {
            throw new UnsupportedOperationException("Unsupported notification type: " + notification);
        }

        EmailNotification target = (EmailNotification) notification;
        for (String recipient : target.getRecipients()) {
            try {
                InternetAddress address = new InternetAddress(recipient);
                address.validate();
            } catch (AddressException e) {
                throw new RuntimeException(e);
            }
        }

        EmailTemplate template = this.template.override(templateFactory, target);
        return new EmailNotificationChannel(
                (EmailNotification) notification,
                emailClient,
                executorService,
                variablesFactory,
                template
        );
    }
}
