package ru.yandex.solomon.alert.notification.channel.email;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class JavamailTransportMetrics {
    private final MetricRegistry registry;
    private final AtomicInteger queueSize = new AtomicInteger();
    private final Histogram sendElapsedTime;
    private final Rate sendQueueOverflow;
    private final ConcurrentHashMap<Integer, Rate> stmpStatusCodes = new ConcurrentHashMap<>();

    public JavamailTransportMetrics(MetricRegistry registry) {
        this.registry = registry;
        registry.lazyGaugeInt64("emailClient.queue.size", queueSize::get);
        sendElapsedTime = registry.histogramRate("emailClient.send.elapsedTime",
                Histograms.exponential(13, 2, 16));
        sendQueueOverflow = registry.rate("emailClient.queue.overflow");
    }

    public void failedSmtpRequest(int code) {
        smtpFailCounter(code).inc();
    }

    public void completeSend(long elapsedTimeMillis) {
        sendElapsedTime.record(elapsedTimeMillis);
    }

    /**
     * https://www.ietf.org/rfc/rfc821.txt
     */
    private Rate smtpFailCounter(int code) {
        return stmpStatusCodes.computeIfAbsent(code,
                c -> registry.rate("emailClient.send.smtp.status", Labels.of("code", String.valueOf(c))));
    }

    int incQueueSize() {
        return queueSize.incrementAndGet();
    }

    void decQueueSize() {
        queueSize.decrementAndGet();
    }

    void queueOverflow() {
        sendQueueOverflow.inc();
    }
}
