package ru.yandex.solomon.alert.notification.channel.email;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mail.MailMessage;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class MailRequest {
    private final MailMessage message;
    private final long deadline;
    private volatile boolean canceled;

    public MailRequest(MailMessage message, long deadline) {
        this.message = message;
        this.deadline = deadline;
    }

    public boolean isCanceled() {
        return canceled;
    }

    public MailMessage getMessage() {
        return message;
    }

    public long getDeadline() {
        return deadline;
    }

    public void cancel() {
        canceled = true;
    }
}
