package ru.yandex.solomon.alert.notification.channel.email;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

import com.google.common.base.Throwables;

import ru.yandex.commune.mail.MailMessage;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;

/**
 * @author Vladimir Gordiychuk
 */
public class MailTransportStub implements MailTransport {
    private final ConcurrentLinkedQueue<MailMessage> sandbox = new ConcurrentLinkedQueue<>();

    public MailMessage receiveMessage() {
        return sandbox.poll();
    }

    public int countMessageInSandbox() {
        return sandbox.size();
    }

    @Override
    public CompletableFuture<NotificationStatus> send(MailRequest request) {
        try {
            // emulate send delay
            TimeUnit.MILLISECONDS.sleep(ThreadLocalRandom.current().nextLong(0, 10));
        } catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }

        sandbox.add(request.getMessage());
        return CompletableFuture.completedFuture(NotificationStatus.SUCCESS);
    }
}
