package ru.yandex.solomon.alert.notification.channel.fallback;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.telegram.TelegramNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.channel.yachats.YaChatsNotificationChannelFactory;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.flags.FeatureFlagsHolder;

@ParametersAreNonnullByDefault
public class FallbackNotificationChannelFactory implements NotificationChannelFactory {

    private final FeatureFlagsHolder flagsHolder;
    private final TelegramNotificationChannelFactory tgChannelFactory;
    private final YaChatsNotificationChannelFactory ymChannelFactory;

    public FallbackNotificationChannelFactory(
            TelegramNotificationChannelFactory tgChannelFactory,
            YaChatsNotificationChannelFactory ymChannelFactory,
            FeatureFlagsHolder flagsHolder)
    {
        this.tgChannelFactory = tgChannelFactory;
        this.ymChannelFactory = ymChannelFactory;
        this.flagsHolder = flagsHolder;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        // see also TelegramNotificationChannelFactory::getSupportTypes
        return Map.of(NotificationType.TELEGRAM, 100);
    }

    @Override
    @Nonnull
    public NotificationChannel createChannel(Notification notification) {
        var tgChannel = tgChannelFactory.createChannel(notification);
        var ymChannel = ymChannelFactory.createChannel(notification);
        return new FallbackNotificationChannel(tgChannel, ymChannel, flagsHolder);
    }
}
