package ru.yandex.solomon.alert.notification.channel.juggler;

import java.time.Clock;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.juggler.client.JugglerClient;
import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.juggler.JugglerNotification;
import ru.yandex.solomon.alert.template.TemplateFactory;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class JugglerNotificationChannelFactory implements NotificationChannelFactory {
    private final Clock clock;
    @WillNotClose
    private final JugglerClient client;
    private final TemplateFactory templateFactory;
    private final TemplateVarsFactory varsFactory;

    public JugglerNotificationChannelFactory(
            Clock clock,
            JugglerClient client,
            TemplateFactory templateFactory,
            TemplateVarsFactory varsFactory) {
        this.clock = clock;
        this.client = client;
        this.templateFactory = templateFactory;
        this.varsFactory = varsFactory;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.JUGGLER, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        if (notification.getType() != NotificationType.JUGGLER) {
            throw new UnsupportedOperationException("Unsupported notification type: " + notification);
        }

        JugglerNotification jugglerDef = (JugglerNotification) notification;
        return new JugglerNotificationChannel(clock, jugglerDef, client, templateFactory, varsFactory);
    }
}
