package ru.yandex.solomon.alert.notification.channel.juggler;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillCloseWhenClosed;

import ru.yandex.juggler.client.JugglerClient;
import ru.yandex.juggler.dto.EventStatus;
import ru.yandex.juggler.dto.GetConfigResponse;
import ru.yandex.juggler.dto.JugglerEvent;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.alert.util.RateLimit;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class RateLimitedJugglerClient implements JugglerClient {
    @WillCloseWhenClosed
    private final JugglerClient client;
    private final RateLimit rateLimit;

    public RateLimitedJugglerClient(@WillCloseWhenClosed JugglerClient client, RateLimit rateLimit)
    {
        this.client = client;
        this.rateLimit = rateLimit;
    }

    @Override
    public CompletableFuture<EventStatus> sendEvent(JugglerEvent event) {
        if (!rateLimit.attempt()) {
            EventStatus status = new EventStatus("Rate limit", HttpStatus.SC_429_TOO_MANY_REQUESTS);
            return completedFuture(status);
        }

        return client.sendEvent(event);
    }

    @Override
    public void close() {
        client.close();
    }

    @Override
    public int estimateCount() {
        return client.estimateCount();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        client.append(tsMillis, commonLabels, consumer);
    }

    @Override
    public void updateTargetConfig(List<GetConfigResponse.Target> config) {
        client.updateTargetConfig(config);
    }
}
