package ru.yandex.solomon.alert.notification.channel.phone;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.jns.client.JnsClient;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.PhoneNotification;
import ru.yandex.solomon.config.protobuf.alert.JNSChannelConfig;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class PhoneNotificationChannelFactory implements NotificationChannelFactory {
    @WillNotClose
    private final JnsClient jnsClient;
    private final JNSChannelConfig config;

    public PhoneNotificationChannelFactory(JnsClient jnsClient, JNSChannelConfig config) {
        this.jnsClient = jnsClient;
        this.config = config;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.PHONE_CALL, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        if (notification.getType() != NotificationType.PHONE_CALL) {
            throw new UnsupportedOperationException("Unsupported notification type: " + notification);
        }

        PhoneNotification target = (PhoneNotification) notification;
        return new PhoneNotificationChannel(target, jnsClient, config);
    }
}
