package ru.yandex.solomon.alert.notification.channel.sms;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.sms.SmsNotification;
import ru.yandex.solomon.alert.template.TemplateFactory;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SmsNotificationChannelFactory implements NotificationChannelFactory {
    private final SmsClient smsClient;
    private final TemplateFactory templateFactory;
    private final SmsTemplate template;
    private final ScheduledExecutorService executorService;
    private final int dailyLimit;

    public SmsNotificationChannelFactory(
            SmsClient smsClient,
            ScheduledExecutorService executorService,
            TemplateFactory templateFactory,
            SmsTemplate template,
            int dailyLimit)
    {
        this.smsClient = smsClient;
        this.executorService = executorService;
        this.templateFactory = templateFactory;
        this.template = template;
        this.dailyLimit = dailyLimit;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.SMS, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        SmsNotification def = (SmsNotification) notification;
        SmsTemplate template = this.template.override(templateFactory, def);
        return new SmsNotificationChannel(def, smsClient, template, executorService, dailyLimit);
    }
}
