package ru.yandex.solomon.alert.notification.channel.sms;

import java.io.IOException;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.domain.sms.SmsNotification;
import ru.yandex.solomon.alert.template.Template;
import ru.yandex.solomon.alert.template.TemplateFactory;

import static ru.yandex.solomon.alert.inject.spring.TemplateUtils.makeTemplateAsResource;

/**
 * @author Vladimir Gordiychuk
 */
public class SmsTemplate {
    private static final String SMS_DEFAULT_TEMPLATE_TEMPLATE = "/ru/yandex/solomon/alert/notification/channel/template/sms/defaultSmsTemplate.mustache";
    private static final String MULTI_ALERT_SMS_DEFAULT_TEMPLATE_TEMPLATE = "/ru/yandex/solomon/alert/notification/channel/template/sms/defaultMultiAlertSmsTemplate.mustache";

    private final Template one;
    private final Template many;
    private final TemplateVarsFactory vars;

    public SmsTemplate(Template one, Template many, TemplateVarsFactory vars) {
        this.one = one;
        this.many = many;
        this.vars = vars;
    }

    public static SmsTemplate create(TemplateFactory templateFactory, TemplateVarsFactory vars) throws IOException {
        Template one = makeTemplateAsResource(templateFactory, SMS_DEFAULT_TEMPLATE_TEMPLATE);
        Template many = makeTemplateAsResource(templateFactory, MULTI_ALERT_SMS_DEFAULT_TEMPLATE_TEMPLATE);
        return new SmsTemplate(one, many, vars);
    }

    public String getText(Event event) {
        return one.process(vars.makeTemplateParams(event));
    }

    public String getText(List<Event> events) {
        return many.process(vars.makeTemplateParams(events));
    }

    public SmsTemplate override(TemplateFactory templateFactory, SmsNotification target) {
        if (!isCustomTemplateDefined(target)) {
            return this;
        }

        Template one = StringUtils.isEmpty(target.getTextTemplate())
                ? this.one
                : templateFactory.createTemplate(target.getTextTemplate());

        return new SmsTemplate(one, many, vars);
    }

    private boolean isCustomTemplateDefined(SmsNotification target) {
        if (!target.getTextTemplate().isEmpty()) {
            return true;
        }

        return false;
    }
}
