package ru.yandex.solomon.alert.notification.channel.sms;

import java.util.concurrent.CompletableFuture;

import com.google.common.base.Strings;

import ru.yandex.solomon.alert.notification.channel.NotificationStatus;
import ru.yandex.staff.StaffClient;

/**
 * @author Vladimir Gordiychuk
 */
public class StaffUserPhoneProvider implements UserPhoneProvider {
    private final StaffClient staffClient;

    public StaffUserPhoneProvider(StaffClient staffClient) {
        this.staffClient = staffClient;
    }

    @Override
    public CompletableFuture<Result> getPhone(String login) {
        return staffClient.getUserInfo(login)
                .thenApply(info -> {
                    if (info.isDismissed()) {
                        return new Result(NotificationStatus.INVALID_REQUEST
                            .withDescription(login + " former employee"));
                    }

                    String phone = info.getPhone();
                    if (Strings.isNullOrEmpty(phone)) {
                        return new Result(NotificationStatus.INVALID_REQUEST
                            .withDescription("Not found phone for user: " + login));
                    }

                    return new Result(info.getPhone());
                });
    }
}
