package ru.yandex.solomon.alert.notification.channel.sms;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.solomon.alert.notification.channel.NotificationStatus;

/**
 * @author Vladimir Gordiychuk
 */
public interface UserPhoneProvider {
    CompletableFuture<Result> getPhone(String login);

    class Result {
        private final NotificationStatus status;
        @Nullable
        private final String phone;

        public Result(String phone) {
            this.status = NotificationStatus.SUCCESS;
            this.phone = phone;
        }

        public Result(NotificationStatus status) {
            this.status = status;
            this.phone = "";
        }

        boolean isOk() {
            return status.getCode() == NotificationStatus.Code.SUCCESS;
        }

        public NotificationStatus getStatus() {
            return status;
        }

        @Nonnull
        public String getPhone() {
            return Objects.requireNonNull(phone);
        }
    }
}
