package ru.yandex.solomon.alert.notification.channel.telegram;

import java.util.Arrays;
import java.util.Base64;

import ru.yandex.solomon.alert.telegram.dto.Button;

/**
 * @author alexlovkov
 **/
public enum ButtonType {
    NOW(0, "Chart now"),
    PAST(1, "Original chart"),
    FALSE_POSITIVE(2, "False positive"),
    MUTE(3, "Mute"),
    UNMUTE(4, "End mute"),

    CANCEL(5, "Cancel"),

    FOR_HOUR(6, "1 hour"),
    TILL_MORNING(7, "Till 10 am"),
    TILL_MONDAY(8, "Till Monday"),

    ALL_SUBALERTS(9, "All subalerts"),
    REPLY_SELECTORS(10, "Choose manually"),
    ;

    private final int number;
    private final String caption;

    ButtonType(int number, String caption) {
        this.number = number;
        this.caption = caption;
    }

    public int getNumber() {
        return number;
    }

    public String getCaption() {
        return caption;
    }

    public record DecodedCallbackData(ButtonType buttonType, String uuid) {
    }

    public static DecodedCallbackData decode(String encodedCallbackData) {
        byte[] decodedBytes = Base64.getDecoder().decode(encodedCallbackData);
        int type = decodedBytes[0];
        String callbackData = new String(Arrays.copyOfRange(decodedBytes, 1, decodedBytes.length));
        return new DecodedCallbackData(byNumber(type), callbackData);
    }

    public Button with(String uuid) {
        byte[] uuidBytes = uuid.getBytes();
        byte[] newBytes = new byte[uuidBytes.length + 1];
        System.arraycopy(uuidBytes, 0, newBytes, 1, uuidBytes.length);
        newBytes[0] = (byte) number;
        byte[] encodedBytes = Base64.getEncoder().encode(newBytes);
        return new Button(caption, new String(encodedBytes));
    }

    public static ButtonType byNumber(int number) {
        for (var button : values()) {
            if (button.getNumber() == number) {
                return button;
            }
        }
        throw new IndexOutOfBoundsException("No button with number " + number);
    }
}
