package ru.yandex.solomon.alert.notification.channel.telegram;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @author alexlovkov
 **/
public interface ChatIdStorage {
    long getChatIdByTelegramLogin(String name);

    long getChatIdByGroupTitle(String groupTitle);

    String resolveGroupTitle(long chatId);

    CompletableFuture<Void> loadAll();

    void removeTelegramLogin(String telegramLogin);

    void removeGroupTitle(String groupChat);

    void addTelegramLogin(long chatId, String login);

    void addGroupTitle(long chatId, String groupTitle);

    List<String> listGroups();
}
