package ru.yandex.solomon.alert.notification.channel.telegram;

/**
 * This controls which keyboard buttons should be attached to the event
 * @author Ivan Tsybulin
 */
public enum EventAppearance {
    /* Backward compatibility */
    UNKNOWN(0),
    /* Sending failed */
    NONE(1),
    /* Screenshots were disabled in channel */
    TEXT_ONLY(2),
    /* Full message with photo, either as one or as two messages */
    WITH_PHOTO(3),
    /* Taking screenshot failed and may be retried */
    PHOTO_FAILED(4),
    /* Taking screenshot failed, retrying won't help */
    PHOTO_EMPTY(5),
    /* Mute was set */
    MUTE_SET(6),
    /* Mute was removed */
    MUTE_REMOVED(7),
    /* Prompt */
    PROMPT_SUBALERT_SELECTORS(8),
    /* Utility event that forwards another event */
    FORWARD(9),
    ;

    private final int number;

    EventAppearance(int number) {
        this.number = number;
    }

    public static EventAppearance forNumber(int number) {
        for (var event : values()) {
            if (event.number == number) {
                return event;
            }
        }
        return UNKNOWN;
    }

    public int getNumber() {
        return number;
    }
}
