package ru.yandex.solomon.alert.notification.channel.telegram;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.alert.EvaluationStatus.Code;
import ru.yandex.solomon.alert.domain.LabelsComparator;
import ru.yandex.solomon.alert.domain.SubAlert;
import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.channel.telegramLike.Payload;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class EventFeatures {
    private EventFeatures() {
    }

    private static int compare(Event left, Event right) {
        int leftVal = left.getState().getStatus().getCode().ordinal();
        int rightVal = right.getState().getStatus().getCode().ordinal();
        int compare = rightVal - leftVal;

        if (compare != 0) {
            return compare;
        }

        Labels leftKey = ((SubAlert) left.getAlert()).getGroupKey();
        Labels rightKey = ((SubAlert) right.getAlert()).getGroupKey();

        return LabelsComparator.INSTANCE.compare(leftKey, rightKey);
    }

    static Payload maybePhotoEvent(boolean sendScreenshot, Event event) {
        if (sendScreenshot && eventNeedsScreenshot(event)) {
            return Payload.ofPhotoEvent(event);
        }

        return Payload.ofTextEvent(event);
    }

    static Payload chooseMaybeOneEventForPhoto(boolean sendScreenshot, /* @NonEmpty */ List<Event> events) {
        if (sendScreenshot) {
            var maybePhotoEvent = events.stream()
                    .filter(EventFeatures::eventNeedsScreenshot)
                    .min(EventFeatures::compare);
            if (maybePhotoEvent.isPresent()) {
                return Payload.ofPhotoEvent(maybePhotoEvent.get());
            }
        }

        return Payload.ofTextEvent(events.stream()
                .min(EventFeatures::compare)
                .get());
    }

    static boolean eventNeedsScreenshot(Event event) {
        var code = event.getState().getStatus().getCode();
        return (code == Code.OK || code == Code.WARN || code == Code.ALARM);
    }
}
