package ru.yandex.solomon.alert.notification.channel.telegram;

import java.util.Objects;

/**
 * @author alexlovkov
 **/
final public class TelegramChat {

    private final long chatId;

    public TelegramChat(long chatId) {
        this.chatId = chatId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TelegramChat that = (TelegramChat) o;
        return chatId == that.chatId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(chatId);
    }

    public long getChatId() {
        return chatId;
    }

    @Override
    public String toString() {
        return "TelegramChat{" +
            "chatId=" + chatId +
            '}';
    }
}
