package ru.yandex.solomon.alert.notification.channel.telegram;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

import ru.yandex.solomon.alert.util.RateLimit;
import ru.yandex.solomon.alert.util.RateLimiters;


/**
 * @author alexlovkov
 **/
public class TelegramLimits {

    private final RateLimit generalRateLimit;
    private final RateLimit rateLimitPerChat;
    private final RateLimit groupRateLimit;
    private final boolean isGroupChat;

    public TelegramLimits(RateLimit generalRateLimit, RateLimit rateLimitPerChat, RateLimit groupRateLimit, boolean isGroupChat) {
        this.generalRateLimit = generalRateLimit;
        this.rateLimitPerChat = rateLimitPerChat;
        this.groupRateLimit = groupRateLimit;
        this.isGroupChat = isGroupChat;
    }

    public static TelegramLimits create(RateLimit generalRateLimit, RawTelegramLimits rawTelegramLimits, boolean isGroupChat) {
        return new TelegramLimits(
            generalRateLimit,
            RateLimiters.create(Math.toIntExact((5L * rawTelegramLimits.getRateLimitPerChat())), Duration.ofSeconds(5)),
            RateLimiters.create(Math.toIntExact((long)(60L * rawTelegramLimits.getGroupRateLimit())), Duration.ofMinutes(1)),
            isGroupChat);
    }

    public Permission attempt() {
        if (!rateLimitPerChat.attempt()) {
            return new Permission(false, TimeUnit.SECONDS.toMillis(1), "chat");
        }
        if (isGroupChat) {
            if (!groupRateLimit.attempt()) {
                return new Permission(false, TimeUnit.MINUTES.toMillis(1), "group");
            }
        }
        if (!generalRateLimit.attempt()) {
            return new Permission(false, TimeUnit.SECONDS.toMillis(1), "common");
        }
        return new Permission(true);
    }

    public static record Permission(boolean havePermit, long waitMillis, String limit) {
        Permission(boolean havePermit) {
            this(havePermit, 0, "");
        }
    }
}
