package ru.yandex.solomon.alert.notification.channel.telegram;

import java.io.IOException;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.domain.telegram.TelegramNotification;
import ru.yandex.solomon.alert.template.Template;
import ru.yandex.solomon.alert.template.TemplateFactory;

import static ru.yandex.solomon.alert.inject.spring.TemplateUtils.makeTemplateAsResource;


/**
 * @author alexlovkov
 **/
public class TelegramTemplate {

    private static final String TELEGRAM_DEFAULT_TEMPLATE_TEMPLATE =
        "/ru/yandex/solomon/alert/notification/channel/template/telegram/defaultTelegramTemplate.mustache";
    private static final String MULTI_ALERT_TELEGRAM_DEFAULT_TEMPLATE_TEMPLATE =
        "/ru/yandex/solomon/alert/notification/channel/template/telegram/defaultMultiAlertTelegramTemplate.mustache";

    private final Template one;
    private final Template many;
    private final TemplateVarsFactory vars;

    public TelegramTemplate(Template one, Template many, TemplateVarsFactory vars) {
        this.one = one;
        this.many = many;
        this.vars = vars;
    }

    public static TelegramTemplate create(TemplateFactory templateFactory, TemplateVarsFactory vars) throws IOException {
        Template one = makeTemplateAsResource(templateFactory, TELEGRAM_DEFAULT_TEMPLATE_TEMPLATE);
        Template many = makeTemplateAsResource(templateFactory, MULTI_ALERT_TELEGRAM_DEFAULT_TEMPLATE_TEMPLATE);
        return new TelegramTemplate(one, many, vars);
    }

    public String getText(Event event) {
        return one.process(vars.makeTemplateParams(event));
    }

    public String getText(List<Event> events) {
        return many.process(vars.makeTemplateParams(events));
    }

    public TelegramTemplate override(TemplateFactory templateFactory, TelegramNotification target) {
        if (!isCustomTemplateDefined(target)) {
            return this;
        }
        Template one = StringUtils.isEmpty(target.getTextTemplate())
            ? this.one
            : templateFactory.createTemplate(target.getTextTemplate());

        return new TelegramTemplate(one, many, vars);
    }

    private boolean isCustomTemplateDefined(TelegramNotification target) {
        if (!target.getTextTemplate().isEmpty()) {
            return true;
        }
        return false;
    }

}
