package ru.yandex.solomon.alert.notification.channel.telegramLike;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.dao.TelegramEventRecord;
import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.channel.telegram.EventAppearance;
import ru.yandex.solomon.alert.telegram.dto.TelegramSendMessage;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public record Payload(Event event, boolean isPhoto, String text) {
    public static Payload ofPhotoEvent(Event event) {
        return new Payload(event, true, "");
    }

    public static Payload ofTextEvent(Event event) {
        return new Payload(event, false, "");
    }

    public Payload withText(String text) {
        return new Payload(event, isPhoto, text);
    }

    private static TelegramEventRecord makeTelegramEventRecord(TelegramSendMessage r, Payload payload, String uuid, EventAppearance eventAppearance) {
        Event event = payload.event();
        return TelegramEventRecord.forAlert(uuid, Instant.now(), r.getMessageId(), event, eventAppearance);
    }

    public PayloadSendResult sendResult(TelegramSendMessage r, String uuid, EventAppearance eventAppearance) {
        return new PayloadSendResult(r, makeTelegramEventRecord(r, this, uuid, eventAppearance));
    }
}
