package ru.yandex.solomon.alert.notification.channel.telegramLike;

import java.util.concurrent.CompletableFuture;

import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;
import ru.yandex.solomon.alert.telegram.dto.TelegramResponse;

public interface TelegramLikeTransport {
    CompletableFuture<PayloadSendResult> sendPayload(String staffLogin, String groupId, long chatId, Payload payload);

    static NotificationStatus classifyStatus(TelegramResponse response) {
        if (HttpStatus.is2xx(response.getCode())) {
            return NotificationStatus.SUCCESS;
        }
        if (HttpStatus.SC_429_TOO_MANY_REQUESTS == response.getCode()) {
            return NotificationStatus.RESOURCE_EXHAUSTED.withDescription(response.getDescription());
        }
        if (HttpStatus.is4xx(response.getCode())) {
            return NotificationStatus.INVALID_REQUEST.withDescription(response.getDescription());
        }
        if (HttpStatus.is5xx(response.getCode())) {
            return NotificationStatus.ERROR_ABLE_TO_RETRY.withDescription(response.getDescription());
        }
        return NotificationStatus.ERROR.withDescription(response.getDescription());
    }
}
