package ru.yandex.solomon.alert.notification.channel.webhook;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import org.apache.commons.lang3.StringUtils;
import org.asynchttpclient.AsyncHttpClient;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;
import ru.yandex.solomon.alert.notification.domain.webhook.WebhookNotification;
import ru.yandex.solomon.alert.template.Template;
import ru.yandex.solomon.alert.template.TemplateFactory;


/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class WebhookNotificationChannelFactory implements NotificationChannelFactory {
    @WillNotClose
    private final AsyncHttpClient asyncHttpClient;
    private final TemplateFactory templateFactory;
    private final Template defaultContentTemplate;
    private final TemplateVarsFactory varsFactory;

    // TODO: default templates
    public WebhookNotificationChannelFactory(
            @WillNotClose AsyncHttpClient asyncHttpClient,
            TemplateFactory templateFactory,
            Template defaultContentTemplate,
            TemplateVarsFactory varsFactory) {
        this.asyncHttpClient = asyncHttpClient;
        this.templateFactory = templateFactory;
        this.defaultContentTemplate = defaultContentTemplate;
        this.varsFactory = varsFactory;
    }

    @Override
    public Map<NotificationType, Integer> getSupportTypes() {
        return Map.of(NotificationType.WEBHOOK, 100);
    }

    @Nonnull
    @Override
    public NotificationChannel createChannel(Notification notification) {
        if (notification.getType() != NotificationType.WEBHOOK) {
            throw new UnsupportedOperationException("Unsupported notification type: " + notification);
        }

        WebhookNotification target = (WebhookNotification) notification;
        Template content = StringUtils.isEmpty(target.getTemplate())
                ? defaultContentTemplate
                : templateFactory.createTemplate(target.getTemplate());

        return new WebhookNotificationChannel(
                (WebhookNotification) notification,
                asyncHttpClient,
                varsFactory,
                content);
    }
}
