package ru.yandex.solomon.alert.notification.channel.yachats;

import ru.yandex.solomon.alert.util.RateLimit;
import ru.yandex.solomon.alert.util.RateLimiters;

/**
 * @author Nikita Minin
 */
public class YaChatsLimits {

    private final RateLimit generalRateLimit;
    private final RateLimit rateLimitPerChat;

    public YaChatsLimits(RateLimit generalRateLimit, RateLimit rateLimitPerChat) {
        this.generalRateLimit = generalRateLimit;
        this.rateLimitPerChat = rateLimitPerChat;
    }

    public static YaChatsLimits create(RateLimit generalRateLimit, YaChatsRawLimits rawYaChatsLimits) {
        return new YaChatsLimits(
            generalRateLimit,
            RateLimiters.create(rawYaChatsLimits.getRateLimitPerChat()));
    }

    public RateLimit getGeneralRateLimit() {
        return generalRateLimit;
    }

    public RateLimit getRateLimitPerChat() {
        return rateLimitPerChat;
    }
}
