package ru.yandex.solomon.alert.notification.channel.yachats;

import java.io.IOException;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.alert.notification.TemplateVarsFactory;
import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.domain.yachats.YaChatsNotification;
import ru.yandex.solomon.alert.template.Template;
import ru.yandex.solomon.alert.template.TemplateFactory;

import static ru.yandex.solomon.alert.inject.spring.TemplateUtils.makeTemplateAsResource;

/**
 * @author Nikita Minin
 */
public class YaChatsTemplate {

    private static final String YA_CHATS_DEFAULT_TEMPLATE_TEMPLATE =
        "/ru/yandex/solomon/alert/notification/channel/template/yachats/defaultYaChatsTemplate.mustache";
    private static final String MULTI_ALERT_YA_CHATS_DEFAULT_TEMPLATE_TEMPLATE =
        "/ru/yandex/solomon/alert/notification/channel/template/yachats/defaultMultiAlertYaChatsTemplate.mustache";

    private final Template one;
    private final Template many;
    private final TemplateVarsFactory vars;

    public YaChatsTemplate(Template one, Template many, TemplateVarsFactory vars) {
        this.one = one;
        this.many = many;
        this.vars = vars;
    }

    public static YaChatsTemplate create(TemplateFactory templateFactory, TemplateVarsFactory vars) throws IOException {
        Template one = makeTemplateAsResource(templateFactory, YA_CHATS_DEFAULT_TEMPLATE_TEMPLATE);
        Template many = makeTemplateAsResource(templateFactory, MULTI_ALERT_YA_CHATS_DEFAULT_TEMPLATE_TEMPLATE);
        return new YaChatsTemplate(one, many, vars);
    }

    public String getText(Event event) {
        return one.process(vars.makeTemplateParams(event));
    }

    public String getText(List<Event> events) {
        return many.process(vars.makeTemplateParams(events));
    }

    public YaChatsTemplate override(TemplateFactory templateFactory, YaChatsNotification target) {
        if (!isCustomTemplateDefined(target)) {
            return this;
        }
        Template one = StringUtils.isEmpty(target.getTextTemplate())
            ? this.one
            : templateFactory.createTemplate(target.getTextTemplate());

        return new YaChatsTemplate(one, many, vars);
    }

    private boolean isCustomTemplateDefined(YaChatsNotification target) {
        return !target.getTextTemplate().isEmpty();
    }

}
