package ru.yandex.solomon.alert.notification.channel.yachats;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.notification.channel.telegram.EventAppearance;
import ru.yandex.solomon.alert.notification.channel.telegramLike.Payload;
import ru.yandex.solomon.alert.notification.channel.telegramLike.PayloadSendResult;
import ru.yandex.solomon.alert.notification.channel.telegramLike.TelegramLikeTransport;
import ru.yandex.solomon.alert.telegram.dto.TelegramSendMessage;
import ru.yandex.solomon.alert.yachats.YaChatsClient;

public class YaChatsTransport implements TelegramLikeTransport {
    private final YaChatsClient client;

    public YaChatsTransport(YaChatsClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<PayloadSendResult> sendPayload(String staffLogin, String groupId, long chatId, Payload payload) {
        return client.sendMessage(staffLogin, groupId, payload.text())
                .thenApply(YaChatsTransport::convertStatus)
                .thenApply(r -> payload.sendResult(r, "", EventAppearance.TEXT_ONLY));
    }

    private static TelegramSendMessage convertStatus(YaChatsClient.Response response) {
        return new TelegramSendMessage(response.getStatusCode(), response.getMessage());
    }
}
