package ru.yandex.solomon.alert.notification.domain;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class DevNullNotification extends Notification {
    private DevNullNotification(Builder builder) {
        super(builder);
    }

    public DevNullNotification(String id, String projectId) {
        this(new Builder().setId(id).setProjectId(projectId));
    }

    @Override
    public NotificationType getType() {
        return NotificationType.UNKNOWN;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder extends Notification.Builder<DevNullNotification, Builder> {
        private Builder() {
        }

        private Builder(DevNullNotification notification) {
            super(notification);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DevNullNotification build() {
            return new DevNullNotification(this);
        }
    }
}
