package ru.yandex.solomon.alert.notification.domain;

/**
 * @author Vladimir Gordiychuk
 */
public enum NotificationType {
    UNKNOWN(0),
    EMAIL(1),
    JUGGLER(2),
    WEBHOOK(3),
    SMS(4),
    TELEGRAM(5),
    CLOUD_EMAIL(6),
    CLOUD_SMS(7),
    YA_CHATS(8),
    DATALENS_EMAIL(9),
    CLOUD_PUSH(10),
    PHONE_CALL(11),
    ;

    private final int number;

    NotificationType(int number) {
        this.number = number;
    }

    public static NotificationType forNumber(int num) {
        for (NotificationType type : values()) {
            if (type.getNumber() == num) {
                return type;
            }
        }

        throw new IllegalArgumentException("Not found type with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
