package ru.yandex.solomon.alert.notification.domain.email;

import java.util.Set;

import com.google.common.collect.ImmutableSet;

import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;

/**
 * @author Vladimir Gordiychuk
 */
public class CloudEmailNotification extends Notification {
    /**
     * Iam user ids
     */
    private final Set<String> recipients;

    private CloudEmailNotification(Builder builder) {
        super(builder);
        this.recipients = ImmutableSet.copyOf(builder.recipients);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Set<String> getRecipients() {
        return recipients;
    }

    @Override
    public NotificationType getType() {
        return NotificationType.CLOUD_EMAIL;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder extends Notification.Builder<CloudEmailNotification, Builder> {
        private Set<String> recipients;

        public Builder() {
        }

        public Builder(CloudEmailNotification notification) {
            super(notification);
            this.recipients = notification.getRecipients();
        }

        @Override
        protected Builder self() {
            return this;
        }

        /**
         * @see CloudEmailNotification#recipients
         */
        public Builder setRecipients(Iterable<String> recipients) {
            this.recipients = ImmutableSet.copyOf(recipients);
            return self();
        }

        /**
         * @see CloudEmailNotification#recipients
         */
        public Builder setRecipient(String recipient) {
            this.recipients = Set.of(recipient);
            return self();
        }

        @Override
        public CloudEmailNotification build() {
            return new CloudEmailNotification(this);
        }
    }
}
