package ru.yandex.solomon.alert.notification.domain.email;

import java.util.Collection;
import java.util.Set;

import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;

/**
 * @author Ivan Tsybulin
 */
public class DatalensEmailNotification extends Notification {
    /**
     * List of email addresses
     */
    private final Set<String> recipients;

    private DatalensEmailNotification(Builder builder) {
        super(builder);
        this.recipients = Set.copyOf(builder.recipients);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Set<String> getRecipients() {
        return recipients;
    }

    @Override
    public NotificationType getType() {
        return NotificationType.DATALENS_EMAIL;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder extends Notification.Builder<DatalensEmailNotification, Builder> {
        private Set<String> recipients;

        public Builder() {
        }

        public Builder(DatalensEmailNotification notification) {
            super(notification);
            this.recipients = notification.getRecipients();
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setRecipients(Collection<String> recipients) {
            this.recipients = Set.copyOf(recipients);
            return self();
        }

        public Builder setRecipient(String recipient) {
            this.recipients = Set.of(recipient);
            return self();
        }

        @Override
        public DatalensEmailNotification build() {
            return new DatalensEmailNotification(this);
        }
    }
}
