package ru.yandex.solomon.alert.notification.domain.sms;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.notification.domain.NotificationType;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class CloudSmsNotification extends Notification {
    private final Set<String> recipientIamIds;

    CloudSmsNotification(Builder builder) {
        super(builder);
        this.recipientIamIds = ImmutableSet.copyOf(builder.recipientIamIds);
    }

    @Override
    public NotificationType getType() {
        return NotificationType.CLOUD_SMS;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    static public Builder newBuilder() {
        return new Builder();
    }

    public Set<String> getRecipients() {
        return recipientIamIds;
    }

    public static class Builder extends Notification.Builder<CloudSmsNotification, Builder> {
        private Set<String> recipientIamIds = Set.of();

        private Builder() {
        }

        public Builder(CloudSmsNotification notification) {
            super(notification);
            this.recipientIamIds = notification.getRecipients();
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setRecipients(Iterable<String> recipientIamIds) {
            this.recipientIamIds = ImmutableSet.copyOf(recipientIamIds);
            return self();
        }

        public Builder setRecipient(String recipientIamId) {
            this.recipientIamIds = Set.of(recipientIamId);
            return self();
        }

        @Override
        public CloudSmsNotification build() {
            return new CloudSmsNotification(this);
        }
    }
}
